DROP PROCEDURE [hips].[HospitalPatientInsert]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Andrew
-- Create date: 15 October 2012
-- Description:   Inserts a new record into the Patient Table
-- =============================================
CREATE PROCEDURE [hips].[HospitalPatientInsert]
(
      @PatientMasterId INT
      ,@HospitalId INT
      ,@Mrn VARCHAR(20)
	  ,@UserModified varchar(256)
)
AS
BEGIN
    SET NOCOUNT ON
    DECLARE @intErrorCode INT,
			@PatientId  INT
    SET @intErrorCode = 0
    INSERT
     INTO [hips].[HospitalPatient]
         ( [PatientMasterId],
           [HospitalId],
           [Mrn],
           [DateCreated],
           [UserCreated],
           [DateModified],
           [UserModified]
         )
    VALUES
         (
            @PatientMasterId
           ,@HospitalId
           ,@Mrn
          , GETDATE()
          , @UserModified
          , GETDATE()
          , @UserModified
         )
    SELECT @intErrorCode = @@ERROR 
           , @PatientId = SCOPE_IDENTITY()
    IF @intErrorCode = 0
    BEGIN
        SELECT 
           PatientId,
           PatientMasterId,
           HospitalId,
           Mrn,
           DateCreated,
           UserCreated,
           DateModified,
           UserModified
         FROM [hips].[HospitalPatient]
         WHERE [PatientId] = @PatientId
    END
    RETURN(@intErrorCode)
END
GO

